<?php 
class ControllerExtensionPaymentVtb extends Controller {
    private $error = array();

    public function index() {
        $this->load->language('extension/payment/vtb');

        $this->document->setTitle($this->language->get('heading_title'));
        
        $this->load->model('setting/setting');
            
        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('vtb', $this->request->post);
            
            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=payment', 'SSL'));
        }

        $data['heading_title'] = $this->language->get('heading_title');
        $data['text_edit'] = $this->language->get('heading_title');

        $data['text_enabled'] = $this->language->get('text_enabled');
        $data['text_disabled'] = $this->language->get('text_disabled');
        $data['text_all_zones'] = $this->language->get('text_all_zones');
        $data['text_yes'] = $this->language->get('text_yes');
        $data['text_no'] = $this->language->get('text_no');
        $data['text_authorization'] = $this->language->get('text_authorization');
        $data['text_sale'] = $this->language->get('text_sale');
        
        $data['shop_login'] = $this->language->get('shop_login');
        $data['shop_password'] = $this->language->get('shop_password');
        $data['shop_id'] = $this->language->get('shop_id');
        $data['shop_url'] = $this->language->get('shop_url');

        $data['entry_order_status_success'] = $this->language->get('entry_order_status_success');
        $data['entry_order_status_fail'] = $this->language->get('entry_order_status_fail');
        $data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
        $data['entry_status'] = $this->language->get('entry_status');
        $data['entry_sort_order'] = $this->language->get('entry_sort_order');
        
        $data['button_save'] = $this->language->get('button_save');
        $data['button_cancel'] = $this->language->get('button_cancel');

    	if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }
        $data['breadcrumbs'] = array();

       	$data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
        	'href'      => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL'),
        	'separator' => false
       	);

        $data['breadcrumbs'][] = array(
            'text'      => $this->language->get('text_payment'),
            'href'      => $this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=payment', 'SSL'),
            'separator' => ' :: '
        );

        $data['breadcrumbs'][] = array(
            'text'      => $this->language->get('heading_title'),
            'href'      => $this->url->link('extension/payment/vtb', 'token=' . $this->session->data['token'], 'SSL'),
            'separator' => ' :: '
        );
                
        $data['action'] = $this->url->link('extension/payment/vtb', 'token=' . $this->session->data['token'], 'SSL');
        
        $data['cancel'] = $this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=payment', 'SSL');

        if (isset($this->request->post['vtb_shop_id'])) {
            $data['vtb_shop_id'] = $this->request->post['vtb_shop_id'];
        } else {
            $data['vtb_shop_id'] = $this->config->get('vtb_shop_id');
        }
        
        if (isset($this->request->post['vtb_shop_login'])) {
            $data['vtb_shop_login'] = $this->request->post['vtb_shop_login'];
        } else {
            $data['vtb_shop_login'] = $this->config->get('vtb_shop_login');
        }
                
        if (isset($this->request->post['vtb_shop_password'])) {
            $data['vtb_shop_password'] = $this->request->post['vtb_shop_password'];
        } else {
            $data['vtb_shop_password'] = $this->config->get('vtb_shop_password');
        }
        
        if (isset($this->request->post['vtb_shop_url'])) {
            $data['vtb_shop_url'] = $this->request->post['vtb_shop_url'];
        } else {
            $data['vtb_shop_url'] = $this->config->get('vtb_shop_url');
        }
        
        if (isset($this->request->post['vtb_order_status_success_id'])) {
            $data['vtb_order_status_success_id'] = $this->request->post['vtb_order_status_success_id'];
        } else {
            $data['vtb_order_status_success_id'] = $this->config->get('vtb_order_status_success_id'); 
        }

        if (isset($this->request->post['vtb_order_status_fail_id'])) {
            $data['vtb_order_status_fail_id'] = $this->request->post['vtb_order_status_fail_id'];
        } else {
            $data['vtb_order_status_fail_id'] = $this->config->get('vtb_order_status_fail_id'); 
        } 

        $this->load->model('localisation/order_status');
        
        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
        
        if (isset($this->request->post['vtb_geo_zone_id'])) {
            $data['vtb_geo_zone_id'] = $this->request->post['vtb_geo_zone_id'];
        } else {
            $data['vtb_geo_zone_id'] = $this->config->get('vtb_geo_zone_id'); 
        } 
        
        $this->load->model('localisation/geo_zone');
                                        
        $data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();
        
        if (isset($this->request->post['vtb_status'])) {
            $data['vtb_status'] = $this->request->post['vtb_status'];
        } else {
            $data['vtb_status'] = $this->config->get('vtb_status');
        }
        
        if (isset($this->request->post['vtb_sort_order'])) {
            $data['vtb_sort_order'] = $this->request->post['vtb_sort_order'];
        } else {
            $data['vtb_sort_order'] = $this->config->get('vtb_sort_order');
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/payment/vtb', $data));
    }

    protected function validate() {
        if (!$this->user->hasPermission('modify', 'extension/payment/vtb')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        
        if (!$this->error) {
            return true;
        } else {
            return false;
        }    
    }
}
?>